/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.CatServer;
import catserver.server.launch.LibrariesManager;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class SparkLoader {
    private static final boolean enableSpark = Boolean.parseBoolean(System.getProperty("catserver.spark.enable", "true"));

    private static boolean isDefaultInstallSpark() {
        return enableSpark && CatServer.getConfig().defaultInstallPluginSpark;
    }

    public static boolean isSparkPluginEnabled() {
        Plugin sparkPlugin = Bukkit.getServer().getPluginManager().getPlugin("spark");
        return sparkPlugin != null && sparkPlugin.isEnabled();
    }

    public static void tryLoadSparkPlugin(SimplePluginManager pluginManager) {
        if (!SparkLoader.isDefaultInstallSpark() || pluginManager.getPlugin("spark") != null) {
            return;
        }
        try {
            File sparkPluginOriginFile = new File(LibrariesManager.librariesDir, "spark-1.8.19-bukkit.jar");
            File sparkPluginFile = new File("plugins", sparkPluginOriginFile.getName());
            if (sparkPluginOriginFile.exists() && !sparkPluginFile.exists()) {
                Files.copy(sparkPluginOriginFile.toPath(), sparkPluginFile.toPath(), new CopyOption[0]);
            }
            if (sparkPluginFile.exists()) {
                Plugin sparkPlugin = pluginManager.loadPlugin(sparkPluginFile);
                sparkPlugin.onLoad();
                pluginManager.enablePlugin(sparkPlugin);
            } else {
                CatServer.log.warn("Missing " + sparkPluginOriginFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            new RuntimeException("Failed to load spark!", e).printStackTrace();
        }
    }
}

